# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
# Makefile for building demo CRS agent programs
#
# Build CRS agents: 
# 
#       make -f demo_agents.mk clean demos
#
# NOTE: 1. ORACLE_HOME and ORA_CRS_HOME must be either:
#                  . set in the user's environment
#                  . passed in on the command line
#                  . defined in a modified version of this makefile
#
#       2. Look in the platform specific documentation for information
#          about environment variables that need to be properly
#          defined (e.g. LD_LIBRARY_PATH).
#   
#       3. Define the CC variable appropriately, to point to your compiler.
#

include $(ORACLE_HOME)/crs/lib/env_has.mk

BUILD = build
DEMOS = demoagent1 demoagent2 macrodemo

# Modify the variables below as appropriate
CC=/usr/bin/g++
DEMO_DIR = $(ORACLE_HOME)/crs/demo
DEMO_MAKEFILE = $(DEMO_DIR)/demo_agents.mk

demos: $(DEMOS)

$(DEMOS):$(OBJS)
	$(MAKE) -f $(DEMO_MAKEFILE) $(BUILD) EXE=$@ OBJS=$@.o	

build: $(OBJS)
	$(CC) -o $(EXE) $(OBJS) $(LDPATHFLAG)$(LIBHOME) \
	$(LDPATHFLAG)$(RDBMSLIB) $(CRSSHAREDLIBS) $(AGFWLIBS)

.cpp.o:
	$(CC) -c $(DEMOINCLUDE) $(HASPUBH) $(OPTIMIZE) $<

clean:
	$(RM) -f $(DEMOS) *.o

